package gov.va.med.mhv.admin.web.formbean;

import gov.va.med.mhv.admin.dto.EmployeeDTO;
import gov.va.med.mhv.admin.dto.EmployeeOrgRoleHistoryDTO;
import gov.va.med.mhv.admin.dto.EmployeeSearchResult;

import java.io.Serializable;
import java.util.List;

/**
 * This bean was created to hold everything about the employee currently under
 * management. Only 1 can be loaded at a time. This class ensures that no
 * lingering parts of one employee can be associated with another employee.
 * 
 * @author DNS
 *
 */
public class ManagedStaffMember implements Serializable {

	private static final long serialVersionUID = 3462746608602950512L;

	private EmployeeDTO managedEmployee = null;
	private EmployeeSearchResult ldapEmployee = null;
	private EmployeeDTO ldapEmployeeToManage = null;
	private List<EmployeeOrgRoleHistoryDTO> roleHistoriesForEmployee;

	public EmployeeDTO getLdapEmployeeToManage() {
		return ldapEmployeeToManage;
	}

	public void setLdapEmployeeToManage(EmployeeDTO employeeToManage) {
		this.ldapEmployeeToManage = employeeToManage;
	}

	public List<EmployeeOrgRoleHistoryDTO> getRoleHistoriesForEmployee() {
		return roleHistoriesForEmployee;
	}

	public void setRoleHistoriesForEmployee(List<EmployeeOrgRoleHistoryDTO> roleHistoriesForEmployee) {
		this.roleHistoriesForEmployee = roleHistoriesForEmployee;
	}

	public EmployeeDTO getManagedEmployee() {
		return managedEmployee;
	}

	public void setManagedEmployee(EmployeeDTO managedEmployee) {
		this.managedEmployee = managedEmployee;
	}

	public EmployeeSearchResult getLdapEmployee() {
		return ldapEmployee;
	}

	public void setLdapEmployee(EmployeeSearchResult ldapEmployee) {
		this.ldapEmployee = ldapEmployee;
	}

	public void clearEmployeeData() {
		managedEmployee = null;
		ldapEmployee = null;
		ldapEmployeeToManage = null;
		roleHistoriesForEmployee = null;
	}

}
